---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：6-next lint

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **next lintコマンドの現在の提供形態**: bin/next.tsに登録がないため、CLI提供の有無を確認すべき
  2. **eslint-config-nextの実装**: パッケージの詳細を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/eslint-plugin-next/src/index.ts` - ESLintプラグインの実装（124行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（lint登録なし）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 21個のESLintルールが提供される | E-01 (60-83行目) | ○ |
| C-02 | recommendedRulesは15 warn + 6 error | E-01 (25-49行目) | ○ |
| C-03 | coreWebVitalsRulesは2ルールをerrorに昇格 | E-01 (51-54行目) | ○ |
| C-04 | 4つの設定プリセットが提供される | E-01 (94-121行目) | ○ |
| C-05 | Flat ConfigとレガシーConfigの両方サポート | E-01 (94-121行目) | ○ |
| C-06 | pluginオブジェクトはmeta, rules, configsを持つ | E-01 (56-85行目) | ○ |
| C-07 | no-html-link-for-pagesはcore-web-vitalsでerrorに昇格 | E-01 (52行目) | ○ |
| C-08 | no-sync-scriptsはcore-web-vitalsでerrorに昇格 | E-01 (53行目) | ○ |
| C-09 | google-font-displayルールが存在 | E-01 (3行目, 61行目) | ○ |
| C-10 | no-img-elementルールが存在 | E-01 (16行目, 74行目) | ○ |
| C-11 | satisfiesキーワードで型チェック | E-01 (49行目, 54行目, 83行目) | ○ |
| C-12 | プラグイン名は@next/eslint-plugin-next | E-01 (58行目) | ○ |
| C-13 | rulesとconfigsをnamed exportする | E-01 (124行目) | ○ |
| C-14 | bin/next.tsにnext lintコマンド登録がある | **根拠なし** | △ |
| C-15 | eslint-config-nextパッケージがプリセット設定を提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- bin/next.tsにlintコマンドの直接登録が確認できなかった。ビルドプロセスやパッケージの別のエントリーポイントで提供されている可能性がある
  - 候補：packages/next/bin/ の別ファイル / packages/next/package.jsonのbin定義 / ビルド時の生成コード
- eslint-config-nextパッケージの実装詳細は未確認
  - 候補：packages/eslint-config-next/の実装確認

## 5) リスクフラグ（レビュー観点）
- 1: next lintコマンドのCLI提供形態が不明確。現行バージョンでの提供方法を要確認
- 0: ESLintプラグインの実装自体は明確に確認できている

## 6) レビュアーチェックリスト（最小）
- [ ] next lintコマンドの現在の提供形態を確認（CLI直接 or ESLintプラグインのみ）
- [ ] 21個のルール名が全て正確にリストされているか
- [ ] ルールレベル（warn/error）の分類が正しいか
- [ ] eslint-config-nextとの関係性を確認
